
### **Overview**

- **What is Configured**:
    - A static point-to-point **Virtual Tunnel Interface (VTI)** for IPsec using [[Internet Key Exchange version 2 (IKEv2)]].
- **Purpose**:
    - Simplifies the process of creating secure VPN tunnels.
    - Provides a routable tunnel interface for site-to-site connectivity.

---

### **Steps for Configuration**

1. **Configure IKEv2 Peering**:
    - Includes setting up:
        - **IKEv2 proposal** (encryption and hashing algorithms, Diffie-Hellman group).
        - **IKEv2 policy** (includes proposals for negotiation).
        - **IKEv2 keyring** (for pre-shared key (PSK) authentication).
        - **IKEv2 profile** (nonnegotiable parameters like local/remote identities and authentication methods).
2. **Configure IPsec Transform Set** (Optional):
    - Defines the security protocols and algorithms (encryption, hashing, encapsulation).
    - Examples:
        - **Encryption algorithm**: AES, 3DES.
        - **Hashing algorithm**: SHA-256.
        - **Encapsulation protocol**: ESP or AH.
3. **Configure IPsec Profile** (Optional):
    - References the IPsec transform set and IKEv2 profile.
    - Summarizes all settings for IPsec security associations (SAs).
4. **Configure the Tunnel Interface**:
    - Apply the IPsec profile using the `tunnel protection` command.
    - Configure the tunnel source (local interface) and destination (peer device’s IP).
    - Ensure the tunnel interface IPs are in the same Layer 3 subnet.
5. **Configure Routing**:
    - Static or dynamic routing to advertise networks reachable over the tunnel.

---

### **IKEv2 Configuration Details**

1. **IKEv2 Proposal**:
    
    - A collection of **transforms** used in negotiating IKE security associations (SAs).
    - Transforms include:
        - **Encryption algorithm**: e.g., AES-CBC, AES-GCM.
        - **Integrity algorithm**: e.g., SHA-256.
        - **Pseudo-Random Function (PRF)**: e.g., SHA-256 (required for AES-GCM).
        - **Diffie-Hellman (DH) group**: e.g., DH Group 19 (256-bit ECDH).
    - Example configurations:
        
        Copy Code
        
        ```none
        crypto ikev2 proposal PROP
         encryption aes-cbc-128
         integrity sha256
         group 19
        ```
        
2. **IKEv2 Policy**:
    
    - References one or more IKEv2 proposals.
    - Used to negotiate encryption, integrity, and key exchange parameters during the IKE_SA_INIT exchange.
    - Example configuration:
        
        Copy Code
        
        ```none
        crypto ikev2 policy POLICY
         proposal PROP
        ```
        
3. **IKEv2 Profile**:
    
    - Defines nonnegotiable parameters, including:
        - Remote and local identities.
        - Authentication methods (e.g., PSK or digital certificates).
    - Example configuration:
        
        Copy Code
        
        ```none
        crypto ikev2 keyring KEYRING
         peer PEER_ROUTER
          address 198.51.100.123
          pre-shared-key local 7c2FKFgNNy
          pre-shared-key remote cpi9w43gYB
        !
        crypto ikev2 profile PROFILE
         match identity remote address 198.51.100.123 255.255.255.255
         identity local address 192.0.2.123
         authentication remote pre-share
         authentication local pre-share
         keyring local KEYRING
        ```
        

---

### **IPsec Configuration Details**

1. **IPsec Transform Set**:
    
    - Defines protocols and algorithms for IPsec SAs, including encryption and hashing.
    - Example configuration:
        
        Copy Code
        
        ```none
        crypto ipsec transform-set TS esp-aes esp-sha256-hmac
         mode tunnel
        ```
        
2. **IPsec Profile**:
    
    - References the transform set and IKEv2 profile.
    - Example configuration:
        
        Copy Code
        
        ```none
        crypto ipsec profile IPSEC_PROFILE
         set transform-set TS
         set ikev2-profile PROFILE
        ```
        

---

### **Tunnel Interface Configuration**

- Configure the VTI for IPsec:
    - Assign a source and destination IP for the tunnel (must be in the same Layer 3 network).
    - Apply the IPsec profile using `tunnel protection`.
- Example configuration:
    
    Copy Code
    
    ```none
    interface Tunnel0
     ip address 10.1.1.1 255.255.255.0
     tunnel source GigabitEthernet0/0
     tunnel destination 198.51.100.123
     tunnel mode ipsec ipv4
     tunnel protection ipsec profile IPSEC_PROFILE
    ```
    

---

### **IKEv2 Smart Defaults**

- Simplifies configuration by providing default settings for IKEv2 proposals, policies, and IPsec profiles.
- Default settings include:
    - **Encryption**: AES-CBC-256.
    - **Integrity**: SHA512, SHA384.
    - **DH Group**: Group 14 (2048-bit MODP), Group 19 (256-bit ECP), etc.
    - **IPsec Transform Set**: ESP with AES encryption and SHA hashing.
- Example:
    
    Copy Code
    
    ```none
    Branch-RTR# show crypto ikev2 proposal default
     IKEv2 proposal: default
         Encryption : AES-CBC-256
         Integrity  : SHA512 SHA384
         PRF        : SHA512 SHA384
         DH Group   : Group 19, Group 14
    ```
    
- Note: Default settings depend on the software version and may not meet specific requirements.

---

### **Advantages of Static VTI with IKEv2**

- **Simplified Configuration**:
    - Reduced complexity compared to crypto maps.
    - Most components are optional due to **IKEv2 Smart Defaults**.
- **Enhanced Security**:
    - Supports advanced encryption and hashing algorithms (e.g., AES-GCM, SHA-256).
    - Uses Diffie-Hellman (DH) groups for secure key exchange.
- **Routing Support**:
    - Enables static or dynamic routing over the tunnel without requiring GRE, reducing bandwidth overhead.
- **Flexibility**:
    - Allows both static and dynamic routing protocols.
    - Integrates easily with Layer 3 networks.

---

### **Real-World Applications**

1. **Site-to-Site VPN**:
    - Provides secure, always-on connectivity between branch offices.
2. **FlexVPN Deployment**:
    - Simplifies deployment as part of a Cisco FlexVPN setup.
3. **High-Security Environments**:
    - Ensures secure communication using advanced cryptographic algorithms.

---

### **Conclusion**

Static VTIs with IKEv2 provide a streamlined, secure, and scalable solution for building point-to-point IPsec VPN tunnels. The use of **IKEv2 Smart Defaults** reduces configuration complexity while providing flexibility for custom setups. This configuration is ideal for site-to-site VPNs requiring advanced security and efficient routing capabilities.